//+------------------------------------------------------------------+  
//|                                                       JsNRTR.mq4 |
//|                    http://www.gustis.narod.ru;     gsb51@mail.ru |
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 2
//----  
#property indicator_color1 Lime 
#property indicator_color2 Red
//----    --------------------------------------------------------------------------------------------------+
extern int  MA_method = 0;  //  
extern int  Length = 12;   //     
extern int  MA_Smooth    = 8; //   
extern int  MA_Phase  = 100;//  ,    -100 ... +100,     ; 
extern int  Smoth_ATR=18;
extern int  Multipiller  = 10; // ; 
extern int  Input_Price_Customs = 0;// ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.)
extern bool Line_Style=false;
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double NRTR[];
double UpTrendBuffer[];
double DownTrendBuffer[];
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+  
//| JsNRTR indicator initialization function                         | 
//+------------------------------------------------------------------+  
int init() 
{  
//---- 3      
IndicatorBuffers(3);
SetIndexBuffer(0,UpTrendBuffer); 
SetIndexBuffer(1,DownTrendBuffer); 
SetIndexBuffer(2,NRTR);
if (Line_Style==true)
 {
  //----      
  SetIndexStyle(0,DRAW_LINE); 
  SetIndexStyle(1,DRAW_LINE); 
 }
else
 {
  //----       
  SetIndexStyle(0,DRAW_ARROW); 
  SetIndexStyle(1,DRAW_ARROW); 
  SetIndexArrow(0,159); 
  SetIndexArrow(1,159); 
 }
//----   ,      
SetIndexEmptyValue(0,0.0);
SetIndexEmptyValue(1,0.0);
//----         
IndicatorShortName ("NRTR( Length="+Length+", Multipiller="+Multipiller+")"); 
SetIndexLabel (0, "Up_Trend");
SetIndexLabel (1, "Down_Trend"); 
//----         
PriceSeriesAlert(Input_Price_Customs);
//----  
return(0); 
} 
//+------------------------------------------------------------------+  
//| JsNRTR iteration function                                        | 
//+------------------------------------------------------------------+  
int start() 
{ 
//----       
if(Bars-1<=MathMax(Length, Smoth_ATR)) return(0);
//----      
double Resalt,ATR,Price,Moving;
//----+        
int bar,limit,MaxBar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,        
MaxBar=Bars-1-MathMax(Length, Smoth_ATR); limit=Bars-1-counted_bars;
//----       Bollinger Bands 
//----            
if (limit>=MaxBar)
     {
      for(bar=Bars-1;bar>=MaxBar;bar--)
       {
         NRTR[bar]=0;
         UpTrendBuffer[bar]=0;
         DownTrendBuffer[bar]=0;
       }
      limit=MaxBar;
     }
//---- 
//----+     
for(bar=limit;bar>=0;bar--)
  {
   DownTrendBuffer[bar]=0;
   UpTrendBuffer  [bar]=0;
   //----+
   ATR =iATR(NULL,0,Smoth_ATR,bar)*Multipiller/10;
   Moving=iCustom(NULL,0,"JMoving Avereges",Length,MA_method,MA_Smooth,MA_Phase,0,Input_Price_Customs,0,bar);
   //----+    PriceSeries     Series
   Price=PriceSeries(Input_Price_Customs,bar+1);
   //-------- -------------
   if(Price>NRTR[bar+1]){Resalt= Moving-ATR; UpTrendBuffer[bar]=Resalt;}
   else
   if(Price<NRTR[bar+1]){Resalt= Moving+ATR; DownTrendBuffer[bar]=Resalt;}
   else  Resalt= Moving;
   NRTR[bar]=Resalt;
  }
//----    
return(0); 
} 

//+----------------------------------------------------------------------------+

